from codeable_detectors.basic_detectors import AtLeastOneFileMatchesDetector, ObjectMethodInvocation
from codeable_detectors.evidences import FailedEvidence, LinkEvidence
from codeable_detectors.pyparsing_patterns import ID
from codeable_detectors.python.pythonDetectors import detect_python_import
from codeable_detectors.utils import update_keyword_args


class PythonPikaAMQPMessageProducerLink(AtLeastOneFileMatchesDetector):
    def __init__(self):
        super().__init__()
        self.file_endings = ["py"]
        self.basic_publish_detector = ObjectMethodInvocation(ID, "basic_publish", "py", closing_semicolon=False)

    def detect_in_context(self, ctx, **kwargs):
        matches = []
        options = update_keyword_args({'channel': None}, kwargs)
        tagged_values = {}
        if options["channel"]:
            tagged_values = {"channel": options["channel"]}

        import_matches = detect_python_import(ctx, "pika")
        if not import_matches:
            return FailedEvidence("python import for pika failed")
        matches.extend(import_matches)

        evidence = self.basic_publish_detector.detect_in_context(ctx, **kwargs)
        if not evidence.has_succeeded():
            return FailedEvidence("cannot find invocation of pika amqp 'basic_publish' method")
        matches.extend(evidence.matches)

        return LinkEvidence(matches).set_properties(detector_link_types=["messageProducer"],
                                                    detector_technology_types=["python", "pika", "amqp"],
                                                    detector_tagged_values=tagged_values,
                                                    kwargs=kwargs)
